
<style type="text/css">
    .panel-dark-green-black{
        
    }
</style>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'balance_sheet'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'balance_sheet'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
        
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'balance_sheet'); ?></h2>
                    
                    <form id="financial-balance-sheet-search-form" action="<?= url('/balance-sheet'); ?>">
                    <div class="row">
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            <select class="form-control chosen-select" name="currency">
                                                <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                                <?php foreach($currencies as $row){ ?>
                                                    <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="form-group">
                                <input type="text" name="limit_positive" value="<?= $search_limit_positive?>" title="+" placeholder="+" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="form-group">
                                <input type="text" name="limit_negative" value="<?= $search_limit_negative?>" title="-" placeholder="-" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                        <div class="col-md-1">
                            <a target="_blank" href="<?= url('/balance-sheet-print').'?'.'currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&limit_positive='.$search_limit_positive.'&limit_negative='.$search_limit_negative; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <?php
                    $search_limit_positive = (float)$search_limit_positive;
                    $search_limit_negative = (float)$search_limit_negative;
                    ?>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 40%;"><?= print_lang($app_lang,'balance_sheet_1st_head'); ?></th>
                                    <th style="width: 20%; text-align: center;"><?= print_lang($app_lang,'balance_sheet_2nd_head'); ?></th>
                                    <th style="width: 20%; text-align: center;"><?= print_lang($app_lang,'balance_sheet_3rd_head'); ?></th>
                                    <th style="width: 20%; text-align: center;"><?= print_lang($app_lang,'balance_sheet_4th_head'); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php 
                                $child_accounts = array(); 
                                $parent_count = 1; 
                                $branch_id = active_branch_id();
                                foreach($root_accounts as $parent_row){
                                    if($parent_row['uid'] == 'cashbook')
                                    {
                                        $child_accounts = fetch_all_cashbooks_branch();
                                    }
                                    else if($parent_row['uid'] == 'client')
                                    {
                                        $child_accounts = fetch_all_clients_branchs();
                                    }
                                    else
                                    {
                                        $child_accounts = std_obj_to_array(DB::table('accounts')->where('branch',$branch_id)->where('type',$parent_row['uid'])->get());
                                    }
                                ?>

                                    <?php
                                    if($parent_row['branch'] == 'general')
                                    {
                                        $parent_name = print_lang($app_lang,'builtin_account_'.$parent_row['uid']);
                                    }
                                    else
                                    {
                                        $parent_name = $parent_row['name'];
                                    }
                                    $parent_balance = _calculate_system_account_type_balance_details(['currency' => $search_currency, 'type' => $parent_row['uid'], 'from' => $search_from, 'to' => $search_to]);
                                    ?>

                                    <tr>
                                        <td colspan="4" style="padding-left: 0; padding-right: 0;">
                                            <div class="panel-group" id="Parent<?= $parent_count; ?>">
                                                <div class="panel" style="border-color:  #1c3b30;">
                                                    <div class="panel-heading" style="min-height: 43px; background-color: #1c3b30; border-color: #1c3b30; color: #fff;">
                                                        <h5 class="panel-title" style="width: 40%; <?php if($app_direction == 'rtl'){echo 'float: right;';}else{echo 'float: left;';}?> display: block;">
                                                            <a data-toggle="collapse" data-parent="#Parent<?= $parent_count; ?>" href="#account-parent-<?= $parent_count; ?>"><i class="fa fa-plus"></i>&nbsp;&nbsp;&nbsp;<?= $parent_name; ?></a>
                                                        </h5>
                                                        <h5 class="panel-title" style="width: 20%; <?php if($app_direction == 'rtl'){echo 'float: right;';}else{echo 'float: left;';}?> display: block; text-align: center;"><?= amount_number_format($parent_balance->debit); ?></h5>
                                                        <h5 class="panel-title" style="width: 20%; <?php if($app_direction == 'rtl'){echo 'float: right;';}else{echo 'float: left;';}?> display: block; text-align: center;"><?= amount_number_format($parent_balance->credit); ?></h5>

                                                        <?php
                                                        // set colors
                                                        $parent_balance_color = ($parent_balance->balance >= 0) ? '#2B9C1B' : '#ec4758';
                                                        ?>

                                                        <h5 class="panel-title" style="width: 20%; color: <?= $parent_balance_color; ?>; <?php if($app_direction == 'rtl'){echo 'float: right;';}else{echo 'float: left;';}?> display: block; text-align: center;"><?= amount_number_format($parent_balance->balance); ?></h5>
                                                    </div>
                                                    <div id="account-parent-<?= $parent_count; ?>" class="panel-collapse collapse">
                                                        <div class="panel-body">
                                                            <table class="table table-striped" style="width: 100%;">
                                                                <?php $child_count = 1; foreach($child_accounts as $child_row){ ?>

                                                                    <?php
                                                                    if($child_row['shared'] == 'yes')
                                                                    {
                                                                        $balance_child = fetch_shared_account_balance_details($child_row['uid'],$search_currency,$child_row['type'],$search_from,$search_to);
                                                                    }
                                                                    else
                                                                    {
                                                                        $balance_child = fetch_account_balance_details($child_row['uid'],$search_currency,$child_row['type'],$search_from,$search_to);
                                                                    }
                                                                    // value limit
                                                                    if($balance_child->balance >= 0)
                                                                    {
                                                                        // positive value limit
                                                                        if($balance_child->balance < $search_limit_positive){ continue; }
                                                                    }
                                                                    else
                                                                    {
                                                                        // negative value limit
                                                                        // -9000 < -8000
                                                                        if($balance_child->balance > $search_limit_negative){ continue; }
                                                                    }

                                                                    // set colors
                                                                    $child_balance_color = ($balance_child->balance >= 0) ? '#2B9C1B' : '#ec4758';
                                                                    ?>

                                                                    <tr style="line-height: 35px;">
                                                                        <td style="width: 40%; text-indent: 20px;"><?= $child_row['name']; ?></td>
                                                                        <td style="width: 20%; text-align: center;"><?= amount_number_format($balance_child->debit); ?></td>
                                                                        <td style="width: 20%; text-align: center;"><?= amount_number_format($balance_child->credit); ?></td>
                                                                        <td style="width: 20%; text-align: center; color: <?= $child_balance_color; ?>;"><?= amount_number_format($balance_child->balance); ?></td>
                                                                    </tr>
                                                                    <?php $child_count++; } ?>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php $parent_count++; } ?>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>